function [s,sd,sx1,sx2,sf] = GP_kernel_leyer(x1,x2,sp,sx1p,sx2p,t,T,param)
[n1,m] = size(x1);
[n2,~] = size(x2);
L = param.L;
sigmaw = param.sigmaw;
sigmau = param.sigmau;
sigmau(1) = sigmau(1)/sqrt(m);
sigmab = param.sigmab;
flag = param.nonlinearity;
s = zeros(n1,n2,L);
sd = zeros(n1,n2,L);
sx1 = zeros(n1,L);
sx2 = zeros(n2,L);
if t == 1
   sigmah = param.sigmah;
   sx1(:,1) =  sigmah^2*sigmaw(1)^2 + (sigmau(1)^2)*sum(x1.*x1,2) + sigmab(1)^2;
   sx2(:,1) =  sigmah^2*sigmaw(1)^2 + (sigmau(1)^2)*sum(x2.*x2,2) + sigmab(1)^2;
   s(:,:,1) =  sigmau(1)^2*(x1*x2') + sigmab(1)^2;
   sd(:,:,1) = gramactcor(s(:,:,1),sx1(:,1),sx2(:,1),flag,2);
   if L > 1
       for l = 2:L
           Vphiu = gramactvar(sx1(:,l-1),flag);
           sx1(:,l) = sigmah^2*sigmaw(l)^2 + sigmau(l)^2*Vphiu + sigmab(l)^2 ;
           Vphiu = gramactvar(sx2(:,l-1),flag);
           sx2(:,l) = sigmah^2*sigmaw(l)^2 + sigmau(l)^2*Vphiu + sigmab(l)^2 ;
           Vphiu = gramactcor(s(:,:,l-1),sx1(:,l-1),sx2(:,l-1),flag,1);
           s(:,:,l) = sigmau(l)^2*Vphiu + sigmab(l)^2;
           sd(:,:,l) = gramactcor(s(:,:,l),sx1(:,l),sx2(:,l),flag,2);
       end
   end
else
    Vphiw = gramactvar(sx1p(:,1),flag);
    sx1(:,1) =  sigmaw(1)^2*Vphiw + (sigmau(1)^2)*sum(x1.*x1,2) + sigmab(1)^2;
    Vphiw = gramactvar(sx2p(:,1),flag);
    sx2(:,1) =  sigmaw(1)^2*Vphiw + (sigmau(1)^2)*sum(x2.*x2,2) + sigmab(1)^2;
    Vphiw = gramactcor(sp(:,:,1),sx1p(:,1),sx2p(:,1),flag,1);
    s(:,:,1) =  sigmaw(1)^2*Vphiw + (sigmau(1)^2)*(x1*x2') + sigmab(1)^2;
    sd(:,:,1) = gramactcor(s(:,:,1),sx1(:,1),sx2(:,1),flag,2);
    if L > 1
        for l = 2:L
           Vphiw = gramactvar(sx1p(:,l),flag); 
           Vphiu = gramactvar(sx1(:,l-1),flag);
           sx1(:,l) = sigmaw(l)^2*Vphiw + sigmau(l)^2*Vphiu + sigmab(l)^2 ;
           
           Vphiw = gramactvar(sx2p(:,l),flag); 
           Vphiu = gramactvar(sx2(:,l-1),flag);
           sx2(:,l) = sigmaw(l)^2*Vphiw + sigmau(l)^2*Vphiu + sigmab(l)^2 ;
           
           Vphiw = gramactcor(sp(:,:,l),sx1p(:,l),sx2p(:,l),flag,1);
           Vphiu = gramactcor(s(:,:,l-1),sx1(:,l-1),sx2(:,l-1),flag,1);
           s(:,:,l) = sigmaw(l)^2*Vphiw + sigmau(l)^2*Vphiu + sigmab(l)^2;
           
           sd(:,:,l) = gramactcor(s(:,:,l),sx1(:,l),sx2(:,l),flag,2); 
        end
    end
    
end
if t == T
    sigmav = param.sigmav;
    sf = sigmav^2*gramactcor(s(:,:,L),sx1(:,L),sx2(:,L),flag,1);
else
    sf = 0;
end


end

